function [errors,clusterreplya, clusterreplyb]=unixcluster(s,m,copymove,filename)
%errors=unixcluster(s,m,copymove,filename)
%  Issue the unix command s to the cluster, annotated with the message m.
%  If the command contains the string 'pscp', and copymove is 'move', then
%  filename will be deleted from the cluster.  Otherwise, copymove and
%  filename are ignored.
%  J.A.Bangham, 2008

    %     disp(s);
    if nargin<3
        copymove='execute';
    end
    if nargin<4
        filename='';
    end
    errors=false;
    disp(sprintf('about to issue command'))
%     disp(s)
    logh=fopen('cluster_logfile.txt','a');
%     fprintf(logh,'%s ',datestr(clock));
%   check that plink and pscp exist on this machine
% Check doesn't work on Mac
% %     if exist('plink.exe')~=2
% %         error('Please install plink.exe into the c:Windows directory by downloading from the putty web page');
% %     end
% %     if exist('pscp.exe')~=2
% %         error('Please install pscp.exe into the c:Windows directory by downloading from the putty web page');
% %     end
    [clusterreplya, clusterreplyb]=system(s); % start newly created shell script
%     fprintf(logh,'%s ',datestr(clock));
    if clusterreplya==0
%         fprintf(logh,'OK %s\n',s);
        fprintf(logh,'OK\n');
    else
%         fprintf(logh,'no %s\n',s);
        fprintf(logh,'no\n');
    end
    fclose(logh);
    
    if strcmp(clusterreplyb,sprintf('Access denied%s%s',char(13),char(10)))
        clusterreplya = 1;
    end
    
    % If using a Mac and Putty cannot be found
    if (~isempty(findstr(clusterreplyb,'plink: command not located')) || ~isempty(findstr(clusterreplyb,'pscp: command not found'))) && ismac==1
        clusterreplyb = sprintf('PuTTY not found. It is either not installed or cannot be found.\nIf it is installed, use setenv to add its path to Matlab''s other environmental paths, e.g.\n');
        clusterreplyb = sprintf('%ssetenv(''PATH'',''/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11/bin:/opt/local/bin'')\n\n',clusterreplyb);
        clusterreplyb = sprintf('%sIf PuTTY is not installed, use MacPorts to install it, e.g.\n',clusterreplyb);
        clusterreplyb = sprintf('%ssudo port install putty',clusterreplyb);
    end
    
    if clusterreplya==0
%         disp(sprintf('%s:  unix cluster replied',m));
        disp(clusterreplyb)

        if strfind(s,'pscp') % i.e. file has been copied
%             if ~isempty(findstr(filename,'.sh')) || ~isempty(findstr(filename,'.m')) || ~isempty(findstr(filename,'.txt'))
%                 % so set up permissions etc.
%                 string2=sprintf('plink -pw %s %s@escluster.uea.ac.uk cd /gpfs/gpfs_esscratch01/sys/%s/; chmod +wx %s; dos2unix %s;',...
%                     getpassword,getyourclustername,getyourclustername,filename,filename);
%                 errors=unixcluster(string2,sprintf('changed permissions %s',filename));
%             end
            if strcmp(copymove,'move') 
                delete(filename)% because copy was successful
                DD=dir(filename);
                if ~isempty(DD)
                    disp(sprintf('%s has not been deleted',filename));
                else
                    disp(sprintf('%s has been moved to cluster (deleted from client)',filename));
                end
            else
                if strfind(s,'@')<50
                    disp(sprintf('%s has been copied from cluster',filename));
                else
                    disp(sprintf('%s has been copied to cluster',filename));
                end
            end
        else
            disp('OK')
        end
    else
        disp(sprintf('\nRemote Unix cluster command executed but not completed: %s, because',m))
        %disp(s)
        disp(clusterreplyb)
        disp('')
        errors=true;
    end
end