function handles = vertexClick( handles, vi, selectionType )
% This should only be called when the simulation is not running.
    if (vi ~= 0)
        fprintf( 1, 'Clicked vertex %d in mode ''%s''.\n', vi, handles.mesh.interactionMode.clickMode );
        switch handles.mesh.interactionMode.clickMode
            case '----'
                % Should forward.
            case { 'Current mgen', 'morphAdd', 'morphSet' }
                fprintf( 1, 'vertexClick mode = %s\n', handles.mesh.interactionMode.clickMode );
                handles = paintVertex( handles, vi, ...
                    strcmp( 'morphAdd', ...
                            handles.mesh.interactionMode.clickMode ) );
                handles = GUIPlotMesh( handles );
            case { 'morphFix' }
                handles = fixVertexMgen( handles, vi );
                handles = GUIPlotMesh( handles );
            case 'Fix nodes'
                handles = fixVertexDF( handles, vi, ...
                    handles.interfacestate.fixedmode.x, ...
                    handles.interfacestate.fixedmode.y, ...
                    handles.interfacestate.fixedmode.z );
                handles = GUIPlotMesh( handles );
            case 'Locate node'
                handles = locateVertexDF( handles, vi, ...
                    handles.interfacestate.fixedmode.x, ...
                    handles.interfacestate.fixedmode.y, ...
                    handles.interfacestate.fixedmode.z );
                handles = GUIPlotMesh( handles );
            case { 'showvalue' }
                mgenIndex = getDisplayedMgenIndex( handles );
                mgenName = handles.mesh.mgenIndexToName{mgenIndex};
                text = sprintf( 'Vx %d: %s = %.3f\n', ...
                    vi, mgenName, handles.mesh.morphogens(vi,mgenIndex) );
                set( handles.siminfoText, 'String', text );
                % Nothing.
            case 'Subdivide vertex'
                % Not implemented.
            otherwise
                fprintf( 1, 'vertexClick: unknown action %s.\n', ...
                    handles.mesh.interactionMode.clickMode );
        end
    end
end
