function [pp,bc] = projectPointToLine( vxs, p )
%[pp,bc] = projectPointToLine( vxs, p )
%   Project P perpendicularly onto the line defined by the two vertexes
%   VXS, giving point P1.  VXS is a 2*D matrix of two row vectors of any
%   dimensionality D.  If the two points coincide, then PP is set equal to
%   both.    BC is set to the barycentric coordinates of the point
%   with respect to VXS, as a 1*D row vector.  The equality PP == BCS*VXS
%   holds.  P may be an N*D matrix of row vectors for any N.

    v21 = vxs(2,:) - vxs(1,:);
    v21dsq = dot(v21,v21);
    if v21dsq==0
        pp = ones(size(p,1),1) * vxs(1,:);
        bc = [ ones(size(p,1),1), zeros(size(p,1),1) ];
    else
        a = (p-repmat(vxs(1,:), size(p,1), 1))*v21'/v21dsq;
        bc = [ 1-a, a ];
        pp = bc*vxs;
    end
end
