function [cells,bcs] = randInTriangles( areas, n, uniformise )
%[cells,bcs] = randInTriangles( areas, n )
%   Generate a set of n random points in the plane, uniformly distributed
%   over the triangles (which are assumed to be disjoint).  The results are
%   returned in the form of cell indexes and barycentric coordinates.

    if (n <= 0) || isempty(areas)
        cells = [];
        bcs = [];
    else
        if nargin < 3
            uniformise = false;
        end
        cells = randBins( areas, n, uniformise );
        bcs = randBaryCoords( n );
    end
end
