function ReplacemorphogensInProject(FileName) %,PathName)
    %function ReplacemorphogensInProject(FileName)
    %
    % Filename, *.morphogens.txt is a text file containing
    %           a list of morphogens to replace those in an existing
    %           project
    % File format
    % MorphogenName [,diffusion constant[,decay rate]]
    %           will generate id_MorphogenName
    %                and       s_MorphogenName with associated properties
    % when no diffusion and decay constants only the id_ will be formed
    if nargin<1
        [FileName,PathName] = uigetfile('*.morphogens.txt','Select a .morphogens.txt file inside project of interest');
        if PathName(end)==filesep
            PathName=PathName(1:end-1);
        end
        currentpath=pwd;
        cd(PathName);
        cd ..
        parentpathname=pwd;
        cd(currentpath);
    end
    s=strfind((FileName),'.morphogens.txt');
    just_creating_file=false;
    if isempty(s)
        % it must be a directory so find the appropriate file in the
        % directory
        PathName=FileName;
        d=dir(fullfile(PathName,['*','.morphogens.txt']));
        if ~isempty(d)
            FileName=d(1).name;
            parentpathname=pwd;
        else
            % there is no file so create one from existing mesh
            [pathstr, name, ext, versn] = fileparts(PathName);%(1:end-1));
            pathstr=pwd;
            [m,OK] = leaf_loadmodel( [], name, pathstr, 'rewrite', 1 );
            FileName=[name,'.morphogens.txt'];
            disp('existing morphogens are')
            m.mgenIndexToName
            parentpathname=pathstr;
            %FileName=
            fh=fopen(fullfile(pathstr,name,FileName),'w');
            if fh~=-1
                [ss,ii]=sort(m.mgenIndexToName);
                for i=1:length(m.mgenIndexToName)
                    ind=ii(i);
                    if ind>=9
                        name=m.mgenIndexToName{ii(i)};
                        fprintf(fh,'%s',name);
                        if lower(name(1))=='s'
                            fprintf(fh,',%f',m.absKvector(1,i));
                            fprintf(fh,',%f\r\n',m.mgen_absorption(i));
                        else
                            fprintf(fh,'\r\n');
                        end
                    end
                end
                fclose(fh);
            end
            just_creating_file=true;
        end
    end

    if ~just_creating_file
        if FileName~=0
            [pathstr, name, ext, versn] = fileparts(PathName);%(1:end-1));
            [m,OK] = leaf_loadmodel( [], name, pathstr, 'rewrite', 1 );
            if OK
                % first delete all user specified existing morphogens, i.e. not first 8
                disp('Prior to deleting')
                m.mgenIndexToName
                m = leaf_delete_mgen(m,m.mgenIndexToName{:});
                disp('Should have deleted all the non-reserved morphogens')
                m.mgenIndexToName
                % read in the *.morphogens file
                disp(sprintf('%s contains ',fullfile(PathName,FileName)))
                type(fullfile(PathName,FileName))
                h=fopen(fullfile(PathName,FileName));
                if h~=-1
                    while ~feof(h)
                        morphdata=fgetl(h);
                        if ~isempty(morphdata)
                            commas=strfind(morphdata,',');
                            if isempty(commas)
                                morph=morphdata;
                                m=leaf_add_morphogen_pair(m,morph);
                            else
                                morph=morphdata(1:commas(1)-1);
                                if length(commas)>1
                                    diffusion=morphdata(commas(1)+1:commas(2)-1);
                                    decay=morphdata(commas(2)+1:end);
                                    m=leaf_add_morphogen_pair(m,morph,str2num(diffusion),str2num(decay));
                                else
                                    diffusion=morphdata(commas(1)+1:end);
                                    m=leaf_add_morphogen_pair(m,morph,str2num(diffusion));
                                end
                            end
                        end
                    end
                    fclose(h);
                    disp('after adding morphogens')
                    m.mgenIndexToName
                    [m,ok] = leaf_savemodel( m,  name, parentpathname);
                    delete(fullfile(parentpathname,name,[name,'_static.mat']));
                else
                    disp(sprintf('Failed to open %s',fullfile(PathName,FileName)))
                end
                if ok
                    disp('Done')
                    disp('Please Reload model using the GFtbox interface');
                else
                    disp('Failed')
                end
            else
                disp('Failed to load mesh model')
            end
        end
    end
end

function m=leaf_add_morphogen_pair(m,name,diffusionK,absorbtionK)
    % name e.g. BASE in which case id_base and s_base are created
    %           id_base in which case id_base is created
    %           s_base in which case s_base is created
    %                  default diffusion and decay constants are 0.01 and 0.1
    if nargin<3
        diffusionK=0.01;
    end
    if nargin<4
        absorbtionK=0.1;
    end
    name=lower(name);
    disp(sprintf('adding %s',name));
    flag=true; % for debugging
    if strcmpi(name(1:3),'id_')
        if flag
            m = leaf_add_mgen( m, name);
        end
        %m = leaf_mgen_modulate( m, 'morphogen', name, 'mutant', 1 );
    elseif strcmpi(name(1:2),'s_')
        if flag
            m = leaf_add_mgen( m, name);
        end
        %m = leaf_mgen_modulate( m, 'morphogen', name, 'mutant', 1 );
        s_name=name;
    elseif strcmpi(name(1:2),'v_')
        if flag
            m = leaf_add_mgen( m, name);
        end
    else
        id_name=lower(['id_',name]);
        s_name =lower(['s_', name]);
        if flag
            m = leaf_add_mgen( m, id_name);
            %m = leaf_mgen_modulate( m, 'morphogen', id_name, 'mutant', 1 );
            m = leaf_add_mgen( m, s_name);
        end
        %m = leaf_mgen_modulate( m, 'morphogen', s_name, 'mutant', 1 );
    end
    if exist('s_name')
        disp(sprintf('adding %s',s_name))
        if flag
            if nargin>2
                m = leaf_mgen_conductivity( m,s_name, diffusionK );
            end
            if nargin==4
                m = leaf_mgen_absorption  ( m,s_name, absorbtionK);
            end
        end
    end
end

