function RunModels(ExperimentNumber,ProjectName)
    % function RunModels(ExperimentNumber,ProjectName)
    % 
    % Runs GFtbox modelling experiments without a user interface
    % View the results using the program: VMS
    %
    % ExperimentNumber, experiment ExperimentNumber should be programmed into the switch
    % ProjectName, default 'sd-pd-ls-200807-19a'
    %
    %J.Andrew Bangham, 2008
    if nargin<1
        ExperimentNumber=1;
    end
    if nargin<2
%         ProjectName='JMotif1';
        ProjectName='sd-pd-ls-200807a-test';
    end
    %Reminder of the arguments to SilentGFtbox
    %SilentGFtbox(...
    %    'Name','IMotif2a',...
    %    'Dir', pwd,...   % current working directory
    %    'N_steps', 20,... % number of steps to be run
    %    'Total_time',80,...    % i.e. number_steps * dt
    %    'dt',[],...            % is set by the project
    %    'Stepsize',1,...       % interval between steps that are recorded
    %    'Mut_list',{'wild'},...% cell array of morphogen names to be set
    %                           %  to zero activity
    %                           % default is 'wildExperimentNumber' i.e. all morph_a=1
    %    'Subdiv_steps',[]);    % array of step numbers at which the whole
    %                           %  FE model should be subdivided
    %
    %On a WINDOWS computer this program is expected to run interactively
    %On  UNIX it is expected to run non-interactively and to set up paths
    %to the toolbox now
    if strcmp(computer,'GLNXA64') 
        % GNU Linux on x86_64
        path(path,genpath(fullfile(pwd,'DArT_Toolshed')));
    end
    disp(sprintf('Running experiment %d using project %s',ExperimentNumber,ProjectName));
    which SilentGFtbox
    path
    switch ExperimentNumber
        case 1
            SilentGFtbox('Name',ProjectName,'Dir', pwd,...
                'N_steps', 10)
        case 2
            SilentGFtbox('Name',ProjectName,'Dir', pwd,...
                'N_steps', 80,'Mut_list',{'CYC','DICH'});
        case 3
            disp('starting C')
            SilentGFtbox('Name','JMotif1','Dir', pwd,'N_steps',80,'Stepsz',1, 'dt',2.5);
            SilentGFtbox('Name','JMotif1','Dir', pwd,'N_steps',10*80,'Stepsz',10, 'dt',0.25);
            SilentGFtbox('Name','JMotif1','Dir', pwd,'N_steps',25*80,'Stepsz',25, 'dt',0.1);
            SilentGFtbox('Name',ProjectName,'Dir', pwd,'N_steps',10*80,'Stepsz',10, 'dt',0.25,'Subdiv_steps',0);
       case 4
            disp('starting 4')
            SilentGFtbox('Name','ArabLeaf4','Dir', pwd,'N_steps',56,'Stepsz',1, 'dt',2.5);
            SilentGFtbox('Name','ArabLeaf4','Dir', pwd,'N_steps',56*10,'Stepsz',10, 'dt',0.25);
        otherwise
            error('experiment is not a recognised ExperimentNumber');
    end
end
