function announceSimStatus( handles, mesh )
%announceSimStatus( handles )
%   Update the report of leaf size, number of iterations, etc. in the GUI
%   display.

    if nargin < 2
        if (~isfield( handles, 'mesh' )) || isempty( handles.mesh )
            s = '';
        else
            s = simStatusString( handles.mesh );
        end
    elseif isempty( mesh )
        s = '';
    else
        s = simStatusString( mesh );
    end
    set( handles.report, 'String', s );
    if isempty(s)
        set( handles.legend, 'String', '' );
    else
        setMyLegend( handles.mesh );
    end
  % fprintf( 1, 'announceSimStatus iter %d\n', handles.mesh.globalDynamicProps.currentIter );
  % drawnow;
end
