function bb = boundingbox( m, extra )
%bb = boundingbox( m, extra )
%   Calculate the bounding box of the mesh m, in a form that can be passed
%   to axis().  If extra is specified, the box is expanded by this amount,
%   e.g. if extra = 0.1 then the box will be 10% large than the exact
%   bounds of the mesh.

    lo = min( m.prismnodes, [], 1 );
    hi = max( m.prismnodes, [], 1 );
    if nargin < 2
        bb = reshape( [ lo; hi ], 1, [] );
    else
        mid = (lo+hi)/2;
        bb = reshape( [ lo + extra*(lo-mid); hi + extra*(hi-mid) ], 1, [] );
    end
end
