function [pos,prismpos] = butterfly( m, ei, tension )
%[pos,prismpos] = butterfly( m, ei )
%   Find the location of the point resulting from subdividing edge ei by
%   the butterfly algorithm.

    if nargin < 3
        tension = 1/16;
    end
    
    [wts,pts] = butterflystencil( m, ei, tension );
    pos = wts*m.nodes(pts,:);
    pts = pts*2;
    prismpos = [ wts*m.prismnodes(pts-1,:); wts*m.prismnodes(pts,:) ];
end
