function handles = cellClick( handles, ci, bc, pt, selectionType )
%handles = cellClick( handles, ci, bc, pt, selectionType )
%   Handle a click on element ci at barycentric coordinates bc and global
%   coordinates pt.
%   This should only be called when the simulation is not running.

%   fprintf( 1, 'cellclick ci %d bc [%.2f %.2f %.2f] pt [%.2f %.2f %.2f] sel ''%s''\n', ...
%       ci, bc, pt, handles.mesh.interactionMode.clickMode );
    if (ci ~= 0) && ~isempty(handles.mesh)
        output = handles.output;
        switch handles.mesh.interactionMode.clickMode
            case { '----', 'morph----' }
                % Should forward.
              % dragviewButtonDownFcn( handles.picture, [] );
            case ''
                % Nothing.
            case 'Delete element'
                attemptCommand( handles, false, true, ... % WARNING: Does not always need redraw.
                    'deletepatch', ci );
                handles = guidata( output );
                handles = GUIPlotMesh( handles );
            case 'bioBedit'
                attemptCommand( handles, false, false, ...
                    'addbioregion', ci );
                handles = guidata( output );
                handles = GUIPlotMesh( handles );
            case 'Subdivide element'
                fprintf( 1, '** Manual subdivision not implemented yet.\n' );
                % Subdivide the cell into four, and split each of the
                % neighbouring cells.
            case { 'Current mgen', 'morphAdd', 'morphSet', 'morphFix', ...
                   'Fix nodes', 'Locate node', 'Subdivide node' }
                % Really a vertex click.
                % Find the hit point and take the closest vertex.
                [mbc,cvi] = max(bc);
                vi = handles.mesh.tricellvxs(ci,cvi);
                handles = vertexClick( handles, vi, selectionType );
            case { 'showvalue' }
                if false
                    % Come here if the plot mode is per-cell and display
                    % the value for the hit cell.
                else
                    % Really a vertex click.
                    % Find the hit point and take the closest vertex.
                    [mbc,cvi] = max(bc);
                    vi = handles.mesh.tricellvxs(ci,cvi);
                    handles = vertexClick( handles, vi, selectionType );
                end
            case { 'Seam edges', 'Subdivide edge', 'Elide edge', 'Elide cell pair' }
                % Really an edge click.
                % Find the hit point and take the closest edge = the most
                % distant vertex.
                [mbc,cei] = min(bc);
                ei = handles.mesh.celledges(ci,cei);
                handles = edgeClick( handles, ei, selectionType );
            otherwise
                fprintf( 1, 'cellClick: unknown action %s.\n', ...
                    handles.mesh.interactionMode.clickMode );
        end
    end
end
