function m = leaf_bowlz( m, varargin )
%m = leaf_bowlz( m, ... )
%   Add a bowl-shaped perturbation to the z coordinate of every point of
%   the finite element mesh.  The z displacement will be proportional to
%   the square of the distance from the origin of coordinates.
%
%   Arguments:
%       A number, being the maximum displacement.  The displacement will be
%       scaled so that the farthest point from the origin is displaced by
%       this amount.  The default is 1.
%
%   Examples:
%       m = leaf_bowlz( m, 2 );
%
%   Equivalent GUI operation: the "Bowl Z" button on the "Mesh editor"
%   panel. The amount of bowl deformation is specified by the value in the
%   upper of the two text boxes to the right of the button.
%
%   Topics: Mesh editing.

    if isempty(m), return; end
    if length( varargin ) ~= 1
        fprintf( 1, '%s: One argument required, %d supplied.\n', ...
            mfilename(), length( varargin ) );
        return;
    end
    [ok1, amount, args] = getTypedArg( mfilename(), {'numeric'}, varargin );
    if ~ok1, return; end

    m = setbowlz( m, amount );
end

