function m = duplicatenode( m, vi, vis )
%m = duplicatenode( m, vi, vis )
%   vis is the set of indexes of duplicates of vertex vi that are to be
%   created.  Replicate all of the per-vertex information for vertex vi,
%   for each of the new vertexes.

    m.nodes(vis,:) = repmat( m.nodes(vi,:), length(vis), 1 );
    pvi = [ vi*2-1, vi*2 ];
    pvis = (vis(:)*2)';
    pvis = reshape( [ pvis-1; pvis ], 1, [] );
    m.prismnodes(pvis,:) = repmat( m.prismnodes(pvi,:), length(vis), 1 );
    if ~isempty(m.displacements)
        m.displacements(pvis,:) = repmat( m.displacements(pvi,:), length(vis), 1 );
    end
    m.morphogens(vis,:) = repmat( m.morphogens(vi,:), length(vis), 1 );
    m.morphogenclamp(vis,:) = repmat( m.morphogenclamp(vi,:), length(vis), 1 );
    m.mgen_production(vis,:) = repmat( m.mgen_production(vi,:), length(vis), 1 );
    m.fixedDFmap(vis,:) = repmat( m.fixedDFmap(vi,:), length(vis), 1 );
    if isfield( m, 'growthTensorPerVertex' )
        m.growthTensorPerVertex(vis,:) = repmat( m.growthTensorPerVertex(vi,:), length(vis), 1 );
    end
end
