function vdfs = findNodeFixedDFs( m, vi )
%vdfs = findNodeFixedDFs( m, vi )
%   Find which degrees of freedom of the triangular mesh node vi are fixed.

    allvdfs = int32( m.globalProps.fixedDFs( ...
                       floor(double(m.globalProps.fixedDFs-1)/6)==(vi-1) ...
                     ) ...
                   ) ...
              - 6*(vi-1);
    vdfs = allvdfs( 1:(length(allvdfs)/2) );
end
