function handles = fixVertexDF( handles, vxs, x, y, z )
%handles = fixVertexDF( handles, vxs, x, y, z )
%   Fix or unfix the degrees of freedom of a vertex.

    output = handles.output;
    handles.mesh = establishInteractionMode( handles.mesh, ...
        'Fix nodes', ...
        handles.interfacestate.fixedmode );
    handles.mesh = updateSelection( handles.mesh, [], [], vxs, 0 );
    isSel = ismember( vxs, handles.mesh.selection.highlightedVxs );
    vxsIn = vxs( isSel );
    vxsOut = vxs( ~isSel );
    if ~isempty( vxsIn )
        dfs = '';
        if x
            dfs = [ dfs 'x' ];
        end
        if y
            dfs = [ dfs 'y' ];
        end
        if z
            dfs = [ dfs 'z' ];
        end
        attemptCommand( handles, false, false, ...
            'fix_vertex', ...
            'vertex', vxsIn, 'dfs', dfs );
        handles = guidata( output );
    end
    if ~isempty( vxsOut )
        attemptCommand( handles, false, false, ...
            'fix_vertex', ...
            'vertex', vxsOut, 'dfs', '' );
        handles = guidata( output );
    end
end
