function m = makeMeshGrowthTensors( m )
%m = makeMeshGrowthTensors( m )
%   Calculate the growth tensors at every vertex of every cell.

    global gOLD_K_PAR gOLD_K_PER gOLD_BEND_PAR gOLD_BEND_PER
    global gOLD_THICKNESS
    global gNEW_KA_PAR gNEW_KA_PER gNEW_KB_PAR gNEW_KB_PER
    global gNEW_K_NOR

    numcells = size(m.tricellvxs,1);
    for ci=1:numcells
        trivxs = m.tricellvxs(ci,:);
        if m.versioninfo.mgenversion==0
            if strcmp( m.globalProps.thicknessMode, 'scaled' )
                gthick = [];
            else
                gthick = m.morphogens( trivxs, gOLD_THICKNESS );
            end
            Glocal = makeLocalGrowthTensor( ...
                        m.morphogens( trivxs, gOLD_K_PAR ), ...
                        m.morphogens( trivxs, gOLD_K_PER ), ...
                        m.morphogens( trivxs, gOLD_BEND_PAR ), ...
                        m.morphogens( trivxs, gOLD_BEND_PER ), ...
                        gthick, ...
                        m.gradpolgrowth(ci,:), ...
                        0 ); % m.globalProps.mingradient );
        else
            switch m.globalProps.thicknessMode
                case { 'scaled', 'direct' }
                    gthick = [];
                otherwise
                    gthick = m.morphogens( trivxs, gNEW_K_NOR );
            end
            Glocal = makeLocalGrowthTensorNEW( ...
                        m.morphogens( trivxs, gNEW_KA_PAR ), ...
                        m.morphogens( trivxs, gNEW_KA_PER ), ...
                        m.morphogens( trivxs, gNEW_KB_PAR ), ...
                        m.morphogens( trivxs, gNEW_KB_PER ), ...
                        gthick, ...
                        m.gradpolgrowth(ci,:), ...
                        0 ); % m.globalProps.mingradient );
        end
        m.celldata(ci).Glocal = Glocal;
        m.celldata(ci).Gglobal = ...
            rotateGrowthTensor( [ Glocal, zeros( size(Glocal,1), 3 ) ], ...
                                m.cellFrames(:,:,ci) );
    end
end
