function perVx = perFEtoperVertex( m, perFE )
%perVx = perFEtoperVertex( m, perFE )
%   Given a quantity that is defined for each finite element, calculate an
%   equivalent quantity per vertex.
%
%   The per-element quantity can be a vector.  If m has numVx vertexes and
%   numFEs finite elements, then perVx has size  [numVxs,K] for some K, and
%   perTri has size [numFEs,K]. 
%
%   Note that this is an approximation: some smoothing is unavoidable in
%   the calculation.  The function perVertextoperFE translates the other
%   way, but these two functions are not inverses.  Converting back and
%   forth will have the side-effect of spreading out the distribution of
%   the quantity.

    numnodes = size(m.nodes,1);
    numdims = size(perFE,2);
    perVx = zeros(numnodes,numdims);
    for i=1:numnodes
        nce = m.nodecelledges{i};
        nbcells = nce(2,:);
        nbcells = nbcells(nbcells ~= 0);
        for j=1:numdims
            perVx(i,j) = sum( m.cellareas(nbcells) .* perFE(nbcells,j) )/sum( m.cellareas(nbcells) );
        end
    end
end
