function saveGFtboxConfig( handles )
    fprintf( 1, 'Writing config to %s.\n', handles.configFilename );
    fid = fopen( handles.configFilename, 'w' );
    if fid ~= -1
        fprintf( fid, 'revnum %d\n', handles.GFtboxRevision );
        fprintf( fid, 'revdate %s\n', handles.GFtboxRevisionDate );
        numdirs = length( handles.userProjectsDirs );
        for i=1:numdirs
            if (numdirs > 1) && strcmp( handles.userProjectsDirs{i}, handles.userProjectsDir );
                s = '* ';
            else
                s = '';
            end
            fprintf( fid, 'projectsdir %s%s\n', s, handles.userProjectsDirs{i} );
        end
        fprintf( fid, 'defaultprojectdir %s\n', handles.userProjectsDir );
        recentprojects = getMenuChildren( handles.recentprojectsMenu );
        for i=1:length(recentprojects)
            ud = get( recentprojects(i), 'UserData' );
            if ~isempty(ud) && isfield( ud, 'modeldir' )
                fprintf( fid, 'recentproject %s\n', ud.modeldir );
            end
        end
        fprintf( fid, 'compressor %s\n', getSelectedCompressor( handles.codecMenu ) );
        if isfield( handles, 'fontdetails' )
            if ~isfield(handles.fontdetails,'FontName')
                handles.fontdetails.FontName=get(0,'FixedWidthFontName');
            end
            fprintf( fid, 'FontName %s\n', handles.fontdetails.FontName );
            fprintf( fid, 'FontUnits %s\n', handles.fontdetails.FontUnits );
            fprintf( fid, 'FontSize %f\n', handles.fontdetails.FontSize );
            fprintf( fid, 'FontWeight %s\n', handles.fontdetails.FontWeight );
            fprintf( fid, 'FontAngle %s\n', handles.fontdetails.FontAngle );
        end
        fprintf( fid, 'bioedgethickness %s\n', get( handles.bioAlinesizeText, 'String' ) );
        fprintf( fid, 'biovertexsize %s\n', get( handles.bioApointsizeText, 'String' ) );
        fprintf( fid, 'Renderer %s\n', handles.Renderer );
        fclose( fid );
    end

    
