function stageTimes = savedStages( m )
%stageTimes = savedStages( m )
%   Return a cell array of the time suffixes of all the stages for which
%   there is a saved state of the mesh, excluding the initial state.

    global gMISC_GLOBALS
    stageTimes = [];
    ss = {};
    if isempty(m), return; end
    if isempty( m.globalProps.projectdir ), return; end
    
    modeldir = getModelDir( m );

    try
        olddir = cd( modeldir );
    catch
        fprintf( 1, 'Cannot find project directory %s.\n', modeldir );
        return;
    end
    
    if ~isempty( find( m.globalProps.modelname=='%', 1 ) )
        fprintf( 1, 'Invalid model name ''%s'': %% sign not allowed.\n', ...
            m.globalProps.modelname );
    else
        setGlobals();
        matfiles = dir([ m.globalProps.modelname, gMISC_GLOBALS.stageprefix, '*.mat' ]);
        for i=1:length(matfiles)
            suffixpart = regexprep( matfiles(i).name, ...
                [ m.globalProps.modelname, gMISC_GLOBALS.stageprefix, '(.*).mat' ], '$1' );
            ss{end+1} = suffixpart;
        end
    end

    if olddir, cd( olddir ); end
    
    stageTimes = [];
    for i=1:length(ss)
        s = regexprep( ss{i}, '[dD]', '.' );
        [t,ok] = sscanf( s, '%f', 1 );
        if ok & ~isempty(t)
            stageTimes(end+1) = t;
        end
    end
end
