function t = stageStringToReal( stagestring )
    if isempty( stagestring )
        t = [];
    elseif strcmp( stagestring, 'restart' )
        t = 0;
    elseif regexp( stagestring, '^[0-9]*[dD][0-9]*$' )
        s = regexprep( stagestring, '[dD]', '.' );
        t = sscanf( s, '%f', 1 );
    elseif regexp( stagestring, '^[0-9]+$' )
        t = sscanf( stagestring, '%f', 1 );
    else
        fprintf( 1, 'Unparseable stage string "%s".\n', stagestring );
        t = 0;
    end
end

