function inside = pointInPoly( pt, poly )
%inside = pointInPoly( pt, poly )
%   Determine whether the point is inside the polygon, by computing the
%   winding number of the polygon about the point.
%   The polygon is represented as an N*2 array containing its vertexes in
%   anticlockwise order.
%   If the points are in clockwise order, the result will be true if the
%   point is outside.

    relpoly = [ poly(:,1) - pt(1), poly(:,2) - pt(2) ];
    inside = windingNumber( grad2( relpoly ) ) > 0;
end

