function h = makeOKButton( fig, pos )
% h = makeOKButton( fig, pos )
%   Make a standard OK button in the given figure at the given
%   position.  FIG can also be a uipanel handle.
    if nargin < 2
        pos = [20 20 60 20];
    end
    h = uicontrol( ...
            'Parent', fig, ...
            'Style', 'pushbutton', ...
            'Tag', 'okButton', ...
            'Units', 'pixels', 'Position', pos, ...
            'Callback', 'exitDialog(gcbo,true)', ...
            'FontWeight', 'bold', ...
            'String', 'OK' );
end
