function saveColor( h )
%saveColor( h )
%   Store the foreground and background color attributes of h in its UserData,
%   so that if we have occasion to temporarily change the colors, we can later
%   restore the original values.

    c = struct();
    try
        c.BackgroundColor = get( h, 'BackgroundColor' );
    catch
    end

    try
        c.ForegroundColor = get( h, 'ForegroundColor' );
    catch
    end

    try
        c.Color = get( h, 'Color' );
    catch
    end
    
    set( h, 'UserData', c );
end
