function cmap = makeCmap( colors, nsteps, frac )
    if nsteps <= 0
        cmap = zeros(0,3);
        return;
    end
    cmap = zeros( nsteps, 3 );
    ncsteps = size(colors,1)-1;
    a = (0:(nsteps))*frac;
    b = a*(ncsteps/nsteps);
    c = floor(b);
    d = b-c;
    e = 1-d;
    for i=1:nsteps
        ci = c(i);
        cmap(i,:) = colors(ci+1,:)*e(i) + colors(ci+2,:)*d(i);
    end
end
