function [a,b] = ab_from_kbend( k, bend, allownegative )
%[a,b] = ab_from_kbend( k, bend )
%   Given growth K and bending BEND, compute the equivalent surface
%   growths A and B, such that K-BEND = A and K+BEND = B.
%   If allownegative is false, A and B are forced to be nonnegative, at the
%   expense of violating the equalities.  The default is that negative
%   values are allowed.

    if nargin < 3
        allownegative = true;
    end
    a = k - bend;
    b = k + bend;
    if ~allownegative
        a = max(a,0);
        b = max(b,0);
    end
end
