function [c,range] = blueRedCmap( range, zerowhite )
%c = blueRedCmap( range, zerowhite )
%   Construct a colour map to represent values ranging from range(1) to
%   range(2).  If zerowhite is true (the default) then the value zero will
%   be mapped to white.  Otherwise the map will go through the rainbox from
%   blue = the minimum to red = the maximum.

    if nargin < 2
        zerowhite = true;
    end
    range = extendToZero( range );
    if range(1)==range(2)
        c = [1 1 1
             1 1 1];
        return;
    end
    negpart = [ 1 1 1
                 0.5 1 0.5
                 0 1 0
                 0 1 1
                 0 0.5 1
                 0 0.2 1 ];
    pospart = [ 1 1 1
                1 1 0.5
                1 1 0
                1 0.5 0
                1 0 0
                0.7 0 0 ];
    c = posnegMap( range, zerowhite, negpart, pospart );
end
