function vertexStuff = cellToVertex( mesh, cellStuff, usemax )
%vertexStuff = cellToVertex( mesh, cellStuff )
%   Convert a quantity defined per cell to a quantity defined per vertex.
%   The vertex value is the average of all the cell values for cells that
%   the vertex belongs to.

    if nargin < 3, usemax = 0; end

    numnodes = size( mesh.nodes, 1 );
    numcells = size( mesh.tricellvxs, 1 );
    if usemax
        initval = -10000;
        vertexStuff = ones( numnodes, 1 ) * initval;
        for i=1:numcells
            vxs = mesh.tricellvxs(i,:);
            vertexStuff( vxs ) = max( vertexStuff( vxs ), cellStuff( i ) );
        end
        vexterStuff( vertexStuff==initval ) = 0;
    else
        vertexStuff = zeros( numnodes, 1 );
        cellcount = zeros( numnodes, 1 );
        for i=1:numcells
            vxs = mesh.tricellvxs(i,:);
            vertexStuff( vxs ) = vertexStuff( vxs ) + cellStuff( i );
            cellcount( vxs ) = cellcount( vxs ) + 1;
        end
        vertexStuff = vertexStuff ./ cellcount;
    end
end
