function lv = cellVectorGlobalToLocal( m, gv )
%lv = cellVectorGlobalToLocal( m, gv )
%   GV contains one vector per finite element of M in global coordinates.
%   LV is the corresponding vector field expressed in local coordinates for
%   each cell.  That is, for every i, LV(i,:) sums to zero, and subject to
%   that, the following equality is satisfied as closely as possible:
%
%       gv(i,:) = lv(i,:) * m.nodes(m.tricellvxs(i,:),:)
%
%   SEE ALSO: cellVectorLocalToGlobal

    lv = zeros(size(gv));
    for i=1:size(m.tricellvxs,1)
        lv(i,:) = localDirection( m.nodes(m.tricellvxs(i,:),:), gv(:,1) );
    end
end
