function [cmap,crange] = chooseColorMap( cmaptype, crange, monocolors )
    if isempty(crange)
        cmap = [ [1 1 1]; [1 1 1] ];
        crange = [0 0];
    else
        switch cmaptype
            case 'blank'
                cmap = [ [1 1 1]; [1 1 1] ];
                crange = [0 1];
            case { 'positive', 'rainbow' }
                [cmap,crange] = positiveRainbow( crange );
            case 'posneg'
                [cmap,crange] = blueRedCmap( crange );
            case 'monochrome'
                [cmap,crange] = monoColormap( crange, monocolors );
            case 'stress'
                [cmap,crange] = stresscolormap( crange );
            case '3rdlayer'
                cmap = [ [ 0.5 0.5 1 ]; [ 1 1 0.8 ] ];
                crange = [ 0 1 ];
            case 'label'
                cmap = [ [ 1, 1, 0 ]; [ 0, 0.5, 0.7 ]; [ 0.8, 0.0, 0 ]; [ 0.8, 0.0, 0 ] ];
                crange = [ 0 3 ];
            otherwise
                fprintf( 1, 'chooseColorMap: unknown type "%s".\n', cmaptype );
        end
    end
end
