function m = leaf_onecell( m, varargin )
%m = leaf_onecell( m, ... )
%   Create a new leaf consisting of a single triangular cell.
%
%   Arguments:
%       M is either empty or an existing mesh.  If it is empty, then an
%       entirely new mesh is created, with the default set of morphogens
%       If M is an existing mesh, then its geometry is replaced by the new
%       mesh.  It retains the same set of morphogens (all set to zero
%       everywhere on the new mesh), interaction function, and all other
%       properties not depending on the specific geometry of the mesh.
%
%   Options:
%       'xwidth'        The diameter in the X dimension.  Default 1.
%       'ywidth'        The diameter in the Y dimension.  Default 1.
%   Example:
%       m = leaf_onecell( [], 'xwidth', 1, 'ywidth', 1 );
%   See also: LEAF_CIRCLE, LEAF_CYLINDER, LEAF_LUNE,
%   LEAF_RECTANGLE, LEAF_SEMICIRCLE.
%
%   Equivalent GUI operation: selecting "One cell" in the pulldown menu in
%   the "Mesh editor" panel and clicking the "Generate mesh" button.
%
%   Topics: Mesh creation.

    [s,ok] = safemakestruct( mfilename(), varargin );
    if ~ok, return; end
    setGlobals();
    global gMAX_MGENVERSION
    s = defaultfields( s, 'xwidth', 1, 'ywidth', 1, ...
        'version', gMAX_MGENVERSION );
    ok = checkcommandargs( 'leaf_onecell', s, 'only', ...
        'xwidth', 'ywidth', 'version' );
    if ~ok, m = []; return; end
    
    newm = onecell( s.xwidth, s.ywidth );
    m = setmeshfromnodes( newm, m, s.version );
    m.meshparams = s;
    m.meshparams.randomness = 0;
    m.meshparams.type = 'oneelement';
end
