function m = disallowNegativeGrowth( m )
%m = disallowNegativeGrowth( m )
%   If m.globalProps.allowNegativeGrowth is false, force all growth
%   morphogens to be non-negative.

    setGlobals();
    global gOLD_K_PAR gOLD_K_PER gOLD_THICKNESS gOLD_K_POL gOLD_BEND_POL
    global gNEW_KA_PAR gNEW_KA_PER gNEW_KB_PAR gNEW_KB_PER gNEW_K_NOR gNEW_POLARISER

    if ~m.globalProps.allowNegativeGrowth
        switch m.versioninfo.mgenversion
            case 0
                growthMgens = [gOLD_K_PAR,gOLD_K_PER,gOLD_THICKNESS,...
                               gOLD_K_POL,gOLD_BEND_POL];
            case 1
                growthMgens = [gNEW_KA_PAR,gNEW_KA_PER, ...
                               gNEW_KB_PAR,gNEW_KB_PER, ...
                               gNEW_K_NOR,gNEW_POLARISER];
            otherwise
                growthMgens = [];
        end
        if ~isempty(growthMgens)
            m.morphogens(:,growthMgens) = ...
                max( m.morphogens(:,growthMgens), 0 );
        end
    end
end
