function nodes = findUnusedNodes( mesh )
    numtrivxs = size( mesh.nodes, 1 );
    cellsPerVertex = zeros( numtrivxs, 1,'int32' );
    numcells = size( mesh.celldata, 2 );
    numtrivxsPerCell = size( mesh.tricellvxs, 2 );
    for ci=1:numcells
        for vi=1:numtrivxsPerCell
            vx = mesh.tricellvxs(ci,vi);
            cellsPerVertex( vx ) = cellsPerVertex( vx ) + 1;
        end
    end
    nodes = find(cellsPerVertex==0);
end

