function h = plotmeshsurface( theaxes, vxs, triangles, data, pervertex, visible, edgethickness, params, userdata )
%h = plotmeshsurface( theaxes, vxs, triangles, data, pervertex, edgethickness, s )
%   Plot a triangular mesh.

    if pervertex
        facecolorinterpmode = 'interp';
        data = data( visible.nodes==1, : );
    else
        facecolorinterpmode = 'flat';
        data = data( visible.cells==1, : );
    end

    [lw,ls] = basicLineStyle( edgethickness );
    arglist = struct2args( params );
    h = patch( ...
        'Faces', triangles, ...
        'Vertices', vxs, ...
        'FaceVertexCData', data, ...
        'FaceColor', facecolorinterpmode, ...
        'LineWidth', lw, ...
        'LineStyle', ls, ...
        'Parent', theaxes, ...
        'ButtonDownFcn', @doMeshClick, ...
        'UserData', userdata, ...
        arglist{:} );
end
