function runUntilButton_Callback(hObject, eventdata, handles)
    if isempty( handles.mesh )
        fprintf( 1, 'No mesh.\n' );
        return;
    end

    if get( handles.runFlag, 'Value' )
        % WARNING: Should ask user.
        beep;
        return;
    end
    
    [ targettime, ok1 ] = ...
        getDoubleFromDialog( handles.simtimeText, 0 );
    if ok1
        setRunning( handles, 1 );
        clearFlag( handles, 'stopButton' );
        oldCursor = get(gcf,'Pointer');
        set(gcf,'Pointer','watch');
        handles.mesh = leaf_iterate( handles.mesh, ...
            0, ...
            'until', targettime, ...
            'plot', 1, ...
            'handles', handles );
        setRunning( handles, 0 );
        guidata(hObject, handles);
        set(gcf,'Pointer',oldCursor);
    end
end
