function m = setmeshgeomfromnodes( m )
%m = setmeshgeomfromnodes( m )
%   Given a mesh containing only nodes and tricellvxs, construct the rest
%   of its geometrical and topological information.

    if isfield( m, 'globalProps' )
        if ~isfield( m.globalProps, 'trinodesvalid' )
            m.globalProps.trinodesvalid = true;
        end
        if ~isfield( m.globalProps, 'prismnodesvalid' )
            m.globalProps.prismnodesvalid = false;
        end
    else
        m.globalProps.trinodesvalid = true;
        m.globalProps.prismnodesvalid = false;
    end

    numnodes = size( m.nodes, 1 );
    m.globalProps.trinodesvalid = true;
    if ~isfield( m, 'prismnodes' )
        m.prismnodes = zeros( numnodes*2, 3 );
    end
    
    % At this point, the following fields are known to exist and be
    % consistent: nodes, prismnodes, tricellvxs, globalProps.trinodesvalid,
    % globalProps.prismnodesvalid.  At least one of the last two should be
    % true.
    
    m = makeedges( m );
    m = fixOrientations( m );
    m = makeVertexConnections(m);
    m = makeedgethreshsq( m );
    m = makeAreasAndNormals( m );
    m.globalProps.initialArea = m.globalDynamicProps.currentArea;
    m.globalProps.bendunitlength = sqrt( m.globalProps.initialArea );
    m.globalDynamicProps.previousArea = m.globalDynamicProps.currentArea;
    m = setlengthscale( m );
    m = makebendangles( m );
    m.initialbendangle = m.currentbendangle;

    m.globalProps.thicknessRelative = 0.5;
    m = setInitialThickness( m );
    if m.globalProps.trinodesvalid ~= m.globalProps.prismnodesvalid
        if m.globalProps.trinodesvalid
            m = makeprismsvalid( m );
        else
            m = makeTRIvalid( m );
        end
    end
    m.displacements = [];
end
