function mesh = squareadj()
%MESH = SQUAREADJ()   Make a triangulated square.
gi = 0;
mesh.trinodesvalid = true;
mesh.prismnodesvalid = false;
mesh.nodes = [ [ 1; 1; 0 ], ...
    [ -1; 1; -0.5 ], ...
    [ -1; -1; 0 ], ...
    [ 1; -1; -0.5 ] ...
  ]';
numpoints = size( mesh.nodes, 1 );
numMorphogens = 1;
mesh.globalProps.activeGrowth = 1;
mesh.globalProps.displayedGrowth = 1;
mesh.morphogens = zeros( numpoints, numMorphogens );
mesh.morphogenclamp = zeros( numpoints, numMorphogens );
edgedata = [ ...
    [ 1, 2, 4, 2, 2, 1, 0.1, 1, 0 ]; ...
    [ 2, 3, 4, 2, 2, 1, 0.1, 1, 0 ]; ...
    [ 3, 4, 4, 2, 2, 1, 0.1, 2, 0 ]; ...
    [ 4, 1, 4, 2, 2, 1, 0.1, 2, 0 ]; ...
    [ 1, 3, 8, sqrt(8), sqrt(8), 1, 0.1, 1, 2 ]
  ];
mesh.edgeends = edgedata(:,1:2);
mesh.edgecells = edgedata(:,8:9);
mesh.edgelinsprings = edgedata(:,3:6);
mesh.edgedamping = edgedata(:,7);
mesh.edgehinges = edgedata(:,10:12);
mesh.tricellvxs = [ ...
    [ 1, 2, 3 ]; ...
    [ 3, 4, 1 ] ...
  ];
mesh.celledges = [ ...
    [ 2, 5, 1 ]; ...
    [ 4, 5, 3 ] ...
  ];
mesh = setlengths(mesh);
end
