function m = updateSelection( m, cis, eis, vis, selecting )
%m = updateSelection( m, vis, cis, eis, selecting )
%   Update the selection with the given cell, vertex, and edge indices.
%   If SELECTING is 2, replace the selection by the given objects.
%   If SELECTING is 1, add all the given objects to the selection.
%   If SELECTING is -1, remove all the given objects from the selection.
%   If SELECTING is 0, toggle the state of all the given objects.

%fprintf( 1, 'updateSelection mode %d\n', selecting );
%vis
%highlightedVxs = m.selection.highlightedVxs

    [m.selection.highlightedCells,cellson,cellsoff] = ...
        updateBoolList( m.selection.highlightedCells, cis, selecting );
    [m.selection.highlightedEdges,edgeson,edgesoff] = ...
        updateBoolList( m.selection.highlightedEdges, eis, selecting );
    [m.selection.highlightedVxs,vxson,vxsoff] = ...
        updateBoolList( m.selection.highlightedVxs, vis, selecting );
end
