function compat = compatibleInteractionMode( m, clickMode, varargin )
%compat = compatibleInteractionMode( m, clickMode, varargin )
%   Determine whether the interaction mode specified by the arguments is
%   compatible with the current mode.  In general, compatibility requires
%   that the clickMode, and where applicable, the extra arguments, have not
%   changed.
%   The extra arguments have the same significance as in
%   setInteractionMode.

    compat = true;
    if isempty(m), return; end
    if strcmp( clickMode, m.interactionMode.clickMode )
        switch clickMode
            case { 'morphAdd', 'morphSet' }
                % Check that paint morphogen and paint value have not changed.
                if (m.interactionMode.paintMorphogen ~= varargin{1}) ...
                        || (m.interactionMode.paintValue ~= varargin{2})
                    compat = false;
                end
            case 'morphFix'
                % Check that paint morphogen has not changed.
                if m.interactionMode.paintMorphogen ~= varargin{1}
                    compat = false;
                end
            case 'Fix nodes'
                compat = isfield( m.interactionMode, 'dfs' ) ...
                       && (m.interactionMode.dfs.x == varargin{1}.x) ...
                       && (m.interactionMode.dfs.y == varargin{1}.y) ...
                       && (m.interactionMode.dfs.z == varargin{1}.z);
            case 'Locate node'
                % Nothing.
            case 'Seam edges'
                % Nothing.
            case 'Subdivide vertex'
                % Nothing.
            case 'Subdivide edge'
                % Nothing.
            case 'Subdivide element'
                % Nothing.
            case 'Elide edge'
                % Nothing.
            case 'Elide cell pair'
                % Nothing.
            otherwise
                % Nothing.
        end
    else
        compat = false;
    end
end
