function varargout = satdisp_sector_coverage(varargin)
% function varargout = satdisp_sector_coverage(varargin)
%
% Display method for showing the proportion of the petal covered by sectors
% in the SA toolbox
%
% Usages:
% satdisp_sector_coverage('parent', gca);
%
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
axish = [];
filename = '';
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'parent'
            axish = varargin{i+1};
        case 'filename'
            filename = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(axish)
    axish = gca;
end
[warped_sector_info, organ_dir] = satio_load_warped_sector_info;
mean_shape = satio_load_mean_shape;
if isempty(mean_shape)
    fprintf(' - could not find a mean shape, exiting\n');
    return;
end
organ_area = polyarea(mean_shape(:,1), mean_shape(:,2));
sector_area = [warped_sector_info.Area];
sector_area(sector_area==0) = [];

sector_area = log2(sector_area/organ_area);
[n, x] = nhist(sector_area, 0.2);
ind = find(n == 0);
n(ind) = [];
x(ind) = [];
perc_pix = (20.*((2.^x).*n));
ph = bar(x, perc_pix,1, 'parent', axish);
grid(axish, 'on');

xlabel(axish, 'log_2(Area(sector)/Area(organ))');
ylabel(axish, 'log_2(# sectors prop. to Area(organ))');
[a, organ_name] = fileparts(organ_dir);
title(axish, ['Image: ', organ_name]);
% keep all the plot handles
varargout{1} = ph;
return
%%%
%
%%%
function [f, d] = nhist(x, bs)
x = sort(x);
L = min(x); U = max(x);
Nbins = (U-L)/bs + 1;
[f, d] = hist(x, Nbins);
return;
