function satio_export_av_grid_data_to_excel
% function satio_export_av_grid_data_to_excel
%
% A function that exports the average sector data for a grid to a file.
%
% See also: satio_list
%
% Dr. A. I. Hanna (2007)

xlcell = {};
grid = satio_opengrid;

[filename, pathname] = uiputfile('*.xls', 'Save as...');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
end


for i=1:length(grid.stage_grids)
    stage = grid.stage_grids{i};
    avsectors = stage.average_sectors;


    j = (i-1)*11 + 1;
    xlcell{j, 1} = stage.stage_info.prev;
    xlcell{j+1, 1} = 'Emaj';
    xlcell{j+2,1} = 'Emin';
    xlcell{j+3,1} = 'theta';


    xlcell{j+5,1} = stage.stage_info.post;

    xlcell{j+6,1} = 'Emaj';
    xlcell{j+7,1} = 'Emin';
    xlcell{j+8,1} = 'theta';

    for ii=1:size(avsectors.prev, 3)
        [maj, min, theta] = gtlib_growthTensor2Params(avsectors.prev(:,:,ii));
        xlcell{j,ii+1} = ii;
        xlcell{j+1,ii+1} = maj;
        xlcell{j+2,ii+1} = min;
        xlcell{j+3,ii+1} = theta;
        [maj, min, theta] = gtlib_growthTensor2Params(avsectors.post(:,:,ii));
        xlcell{j+5,ii+1} = ii;
        xlcell{j+6,ii+1} = maj;
        xlcell{j+7,ii+1} = min;
        xlcell{j+8,ii+1} = theta;
    end

end
xlswrite([pathname, filesep, filename], xlcell);
return