function satio_export_growth_data_to_excel
% function satio_export_growth_data_to_excel
%
% A function that exports the growth data from an ungrowth file to excel
%
% See also: satio_list
%
% Dr. A. I. Hanna (2007)

% open the ungrowth data
[ungrowth_data, ungrowth_name] = satio_load_ungrowth;
if isempty(ungrowth_data)
    return;
end
[a, ungrowth_name] = fileparts(ungrowth_name);
% pick an excel file to store the data
[filename, pathname] = uiputfile('*.xls', 'Save as...', [pwd, filesep, 'growth_data_', ungrowth_name, '.xls']);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel');
    return
else
    excel_filename = [pathname, filesep, filename];
end
deltaSt = 20;
if ~isfield(ungrowth_data, 'stage_delta_t')
    fprintf(' cannot find a stage_delta_t using default value: %f\n', T);
else
    deltaSt = ungrowth_data.stage_delta_t;
end

for i=1:length(ungrowth_data.ungrown_grids)-1
    ungrowth_data.ungrown_grids{i+1}.mesh_ungrowth_tensors = satio_meshes2GrowthData(ungrowth_data.ungrown_grids{i}, ungrowth_data.ungrown_grids{i+1}, deltaSt);    
end


G1 = createGrowthSheet1(ungrowth_data);


[success, message] = xlswrite(excel_filename, G1, 'Growth Rates (Stage View)');


G1_mesh = createMeshGrowthSheet1(ungrowth_data);
[success, message] = xlswrite(excel_filename, G1_mesh, 'Mesh Growth Rates (Stage View)');


G2 = createGrowthSheet2(ungrowth_data);
[success, message] = xlswrite(excel_filename, G2, 'Growth Rates (Region View)');


G2_mesh = createMeshGrowthSheet2(ungrowth_data);
[success, message] = xlswrite(excel_filename, G2_mesh, 'Mesh Growth Rates (Region View)');

return
%%
function G = createGrowthSheet2(ungrowth_data)

ug = ungrowth_data.ungrown_grids;
T = 20;
if ~isfield(ungrowth_data, 'stage_delta_t')
    fprintf(' cannot find a stage_delta_t using default value: %f\n', T);
else
    T = ungrowth_data.stage_delta_t;
end

numStages = length(ug);
numRegions = size(ug{1}.ungrowth_tensors, 3);


G = {};
stage_names = ug{1}.stage_info.stages;
% Make the sheet ready for saving to excel
c = 18;


for r = 1:numRegions
    
    rind = (r-1)*(numStages+2) + 1;
    
    
    G{rind,1} = ['Region: ', num2str(r)];
    G{rind,2} = 'Stage';
    G{rind,3} = 'deltaSt';
    G{rind,4} = 'Smaj';
    G{rind,5} = 'Smin';
    G{rind,6} = 'Sarea';
    G{rind,7} = 'Kmaj';
    G{rind,8} = 'Kmin';
    G{rind,9} = 'Karea';
    G{rind,10} = 'Kmaj/Kmin';
    G{rind,11} = 'Rmaj';
    G{rind,12} = 'Rmin';
    G{rind,13} = 'Rarea';
    G{rind,14} = 'Dmaj';
    G{rind,15} = 'Dmin';
    G{rind,16} = 'Darea';
    G{rind,17} = 'Theta';
   
    for s = 1:numStages-1
        growthrates = growthParameters2GrowthRates(ug{s+1}.ungrowth_tensors(:,:,r), T);
        G{rind+s, 2} = stage_names{s+1};
        G{rind+s, 3} = T;
        G{rind+s, 4} = growthrates.Smaj;
        G{rind+s, 5} = growthrates.Smin;
        G{rind+s, 6} = growthrates.Sarea;
        G{rind+s, 7} = growthrates.Kmaj;
        G{rind+s, 8} = growthrates.Kmin;
        G{rind+s, 9} = growthrates.Karea;
        G{rind+s, 10} = growthrates.Kanis;
        G{rind+s, 11} = growthrates.Rmaj;
        G{rind+s, 12} = growthrates.Rmin;
        G{rind+s, 13} = growthrates.Rarea;
        G{rind+s, 14} = growthrates.Dmaj;
        G{rind+s, 15} = growthrates.Dmin;
        G{rind+s, 16} = growthrates.Darea;
        G{rind+s, 17} = growthrates.theta;
    end
    
end
return
%%
function G = createMeshGrowthSheet2(ungrowth_data)

ug = ungrowth_data.ungrown_grids;
T = 20;
if ~isfield(ungrowth_data, 'stage_delta_t')
    fprintf(' cannot find a stage_delta_t using default value: %f\n', T);
else
    T = ungrowth_data.stage_delta_t;
end

numStages = length(ug);
numRegions = size(ug{1}.ungrowth_tensors, 3);


G = {};
stage_names = ug{1}.stage_info.stages;
% Make the sheet ready for saving to excel
c = 18;


for r = 1:numRegions
    
    rind = (r-1)*(numStages+2) + 1;
    
    
    G{rind,1} = ['Region: ', num2str(r)];
    G{rind,2} = 'Stage';
    G{rind,3} = 'deltaSt';
    G{rind,4} = 'Smaj';
    G{rind,5} = 'Smin';
    G{rind,6} = 'Sarea';
    G{rind,7} = 'Kmaj';
    G{rind,8} = 'Kmin';
    G{rind,9} = 'Karea';
    G{rind,10} = 'Kmaj/Kmin';
    G{rind,11} = 'Rmaj';
    G{rind,12} = 'Rmin';
    G{rind,13} = 'Rarea';
    G{rind,14} = 'Dmaj';
    G{rind,15} = 'Dmin';
    G{rind,16} = 'Darea';
    G{rind,17} = 'Theta';
    for s = 1:numStages-1
        growthrates = growthParameters2GrowthRates(ug{s+1}.mesh_ungrowth_tensors(:,:,r), T);
        G{rind+s, 2} = stage_names{s+1};
        G{rind+s, 3} = T;
        G{rind+s, 4} = growthrates.Smaj;
        G{rind+s, 5} = growthrates.Smin;
        G{rind+s, 6} = growthrates.Sarea;
        G{rind+s, 7} = growthrates.Kmaj;
        G{rind+s, 8} = growthrates.Kmin;
        G{rind+s, 9} = growthrates.Karea;
        G{rind+s, 10} = growthrates.Kanis;
        G{rind+s, 11} = growthrates.Rmaj;
        G{rind+s, 12} = growthrates.Rmin;
        G{rind+s, 13} = growthrates.Rarea;
        G{rind+s, 14} = growthrates.Dmaj;
        G{rind+s, 15} = growthrates.Dmin;
        G{rind+s, 16} = growthrates.Darea;
        G{rind+s, 17} = growthrates.theta;
    end
end
return
%%
function G = createGrowthSheet1(ungrowth_data)

ug = ungrowth_data.ungrown_grids;
T = 20;
if ~isfield(ungrowth_data, 'stage_delta_t')
    fprintf(' cannot find a stage_delta_t using default value: %f\n', T);
else
    T = ungrowth_data.stage_delta_t;
end

N = length(ug);
G = {};
stage_names = ug{1}.stage_info.stages;
% Make the sheet ready for saving to excel
c = 18;

for i=1:N-1
    [doubling_time, anisotropy, theta] = growthParameters2GrowthRateAnisotropy(ug{i+1}.ungrowth_tensors, T);
    
    G{c*i-17,1} = stage_names{i+1};
    G{c*i-16,1} = 'Stage';
    G{c*i-15,1} = 'deltaSt';
    G{c*i-14,1} = 'Smaj';
    G{c*i-13,1} = 'Smin';
    G{c*i-12,1} = 'Sarea';
    G{c*i-11,1} = 'Kmaj';
    G{c*i-10,1} = 'Kmin';
    G{c*i-9,1} = 'Karea';
    G{c*i-8,1} = 'Kmaj/Kmin';
    G{c*i-7,1} = 'Rmaj';
    G{c*i-6,1} = 'Rmin';
    G{c*i-5,1} = 'Rarea';
    G{c*i-4,1} = 'Dmaj';
    G{c*i-3,1} = 'Dmin';
    G{c*i-2,1} = 'Darea';
    G{c*i-1,1} = 'Theta';
 
    for j=1:length(anisotropy)
        growthrates = growthParameters2GrowthRates(ug{i+1}.ungrowth_tensors(:,:,j), T);
        G{c*i-16, j+1} = j;
        G{c*i-15, j+1} = T;
        G{c*i-14, j+1} = growthrates.Smaj;
        G{c*i-13, j+1} = growthrates.Smin;
        G{c*i-12, j+1} = growthrates.Sarea;
        G{c*i-11, j+1} = growthrates.Kmaj;
        G{c*i-10, j+1} = growthrates.Kmin;
        G{c*i-9, j+1} = growthrates.Karea;
        G{c*i-8, j+1} = growthrates.Kanis;
        G{c*i-7, j+1} = growthrates.Rmaj;
        G{c*i-6, j+1} = growthrates.Rmin;
        G{c*i-5, j+1} = growthrates.Rarea;
        G{c*i-4, j+1} = growthrates.Dmaj;
        G{c*i-3, j+1} = growthrates.Dmin;
        G{c*i-2, j+1} = growthrates.Darea;
        G{c*i-1, j+1} = growthrates.theta;
    end
end
return
%%
function G = createMeshGrowthSheet1(ungrowth_data)

ug = ungrowth_data.ungrown_grids;
T = 20;
if ~isfield(ungrowth_data, 'stage_delta_t')
    fprintf(' cannot find a stage_delta_t using default value: %f\n', T);
else
    T = ungrowth_data.stage_delta_t;
end

N = length(ug);
G = {};
stage_names = ug{1}.stage_info.stages;
% Make the sheet ready for saving to excel
c = 18;

for i=1:N-1
    [doubling_time, anisotropy, theta] = growthParameters2GrowthRateAnisotropy(ug{i+1}.ungrowth_tensors, T);
    G{c*i-17,1} = stage_names{i+1};
    G{c*i-16,1} = 'Stage';
    G{c*i-15,1} = 'deltaSt';
    G{c*i-14,1} = 'Smaj';
    G{c*i-13,1} = 'Smin';
    G{c*i-12,1} = 'Sarea';
    G{c*i-11,1} = 'Kmaj';
    G{c*i-10,1} = 'Kmin';
    G{c*i-9,1} = 'Karea';
    G{c*i-8,1} = 'Kmaj/Kmin';
    G{c*i-7,1} = 'Rmaj';
    G{c*i-6,1} = 'Rmin';
    G{c*i-5,1} = 'Rarea';
    G{c*i-4,1} = 'Dmaj';
    G{c*i-3,1} = 'Dmin';
    G{c*i-2,1} = 'Darea';
    G{c*i-1,1} = 'Theta';
  
    
    
    for j=1:length(anisotropy)
          growthrates = growthParameters2GrowthRates(ug{i+1}.mesh_ungrowth_tensors(:,:,j), T);
        G{c*i-16, j+1} = j;
        G{c*i-15, j+1} = T;
        G{c*i-14, j+1} = growthrates.Smaj;
        G{c*i-13, j+1} = growthrates.Smin;
        G{c*i-12, j+1} = growthrates.Sarea;
        G{c*i-11, j+1} = growthrates.Kmaj;
        G{c*i-10, j+1} = growthrates.Kmin;
        G{c*i-9, j+1} = growthrates.Karea;
        G{c*i-8, j+1} = growthrates.Kanis;
        G{c*i-7, j+1} = growthrates.Rmaj;
        G{c*i-6, j+1} = growthrates.Rmin;
        G{c*i-5, j+1} = growthrates.Rarea;
        G{c*i-4, j+1} = growthrates.Dmaj;
        G{c*i-3, j+1} = growthrates.Dmin;
        G{c*i-2, j+1} = growthrates.Darea;
        G{c*i-1, j+1} = growthrates.theta;
        
      
    end
end
return