function varargout = satio_load_ungrowth(varargin)
% function varargout = satio_load_ungrowth(varargin)
%
% IO Method for loading ungrowth data in the SA toolbox
%
% Usages: 
% ungrowth_data = satlib_load_ungrowth('filename', filename);
% or 
% ungrowth_data = satlib_load_ungrowth;
%
%
% See also: satio_list
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
ungrowth_data = [];
ug_dir = ['Staged', filesep, 'Data', filesep, 'UngrowthData', filesep];
filename = '';
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'filename'
            filename = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(filename)
    [filename, pathname] = uigetfile('*.mat', 'Open Ungrowth Data...', ug_dir);
    if isequal(filename,0) || isequal(pathname,0)
        disp('User pressed cancel');
        varargout{1} = [];
        varargout{2} = filename;
        return;
    end
    filename = [pathname, filesep, filename];
end
ungrowth_data = load(filename);
if ~isfield(ungrowth_data, 'grid_name')
    fprintf('Invalid ungrowth file\n');
    ungrowth_data = [];
    return;
end
varargout{1} = ungrowth_data;
varargout{2} = filename;
return



