function satlib_individualsectorStats2Excel(varargin)

[prjpath, stagedDirString, sector_files] = satlib_getSectorNames;
if isempty(sector_files)
    return;
end

% get the user selected excel file to save to
[xlsfilename, xlspathname] = uiputfile('*.csv', 'Pick an file', [pwd, filesep]);
if isequal(xlsfilename,0) || isequal(xlspathname,0)
    disp('User pressed cancel');
    return;
end

N = length(sector_files);
for i=1:N
    filename = sector_files{i};
    filenameMinusExtension = filename(1:max(strfind(sector_files{i},filesep))-1);
    fprintf('Processing file: %s\n', filenameMinusExtension);
    currentLocation = [prjpath,filesep,filenameMinusExtension];
    data{i} = getSectorData(currentLocation);    
end
%write data to csvfile
writeToCsv(data,xlsfilename,xlspathname)
return

function writeToCsv(data,xlsfilename,xlspathname)
file_1 = fopen([xlspathname,xlsfilename],'w');
header = ['Filename',',','Sector Number',',','Warped Major Axis',',','Warped Minor Axis',',','Warped Theta'];
fprintf(file_1,[header,'\n']);
for i = 1:length(data)
    name = data{i}.file;
    name = name(max(strfind(name,filesep))+1:end);
    
     for j = 1:length(data{i}.warped_major)
        line = [name,',',num2str(j),',',num2str(data{i}.warped_major(j)),',',num2str(data{i}.warped_minor(j)),',',num2str(data{i}.warped_theta(j))];
        fprintf(file_1,[line,'\n']);
    end    
end
fclose(file_1)
return

function data = getSectorData(currentLocation)
    %load warped_sector_info.mat
    load([currentLocation,filesep,'warped_sector_info.mat']);
    data.file = currentLocation;
    %loop through all sectors
    for i = 1:length(warped_sector_info)
       [data.warped_major(i), data.warped_minor(i), data.warped_theta(i)] = gtlib_growthTensor2Params(warped_sector_info(i).growthTensor);
    end
    %remember to *2 major and minor axis cos gtlib_growthTensor2Params
    %measures from centroid
%     data.warped_major = data.warped_major .*2;
%     data.warped_minor = data.warped_minor .*2;
    data.warped_major = data.warped_major;
    data.warped_minor = data.warped_minor;
    
return


function [prjpath, stagedDirString, sector_files] = satlib_getSectorNames
stagedDirString = 'Staged';
prjpath = pwd;
sector_files = FindFilenames('_sectors.tif', stagedDirString);

fprintf('Generating excel statistics file\n');
[s,v] = listdlg('PromptString','Select files to generate statistics:', ...
    'SelectionMode','multiple', 'ListSize', [600 300],...
    'ListString',sector_files);
if v == 0
    sector_files = [];
    return;
end
sector_files = sector_files(s);
return