function [x, n] = get_warped_stage_data(stage_dir, number_of_pixels_per_cell)
% function [x, n] = get_warped_stage_data(stage_dir, number_of_pixels_per_cell)
%
% A function that takes a stage directory and a scalar that defines the
% number of pixels per cell.
%
% Returns the center of the bins and the frequency of a particular sector
% size for that stage. This can then be used in a histogram plot to stage
% images.
%
% Dr. A. I. Hanna (2006)
files = findfiles('warped_sector_info.mat', stage_dir);
area = [];
for i=1:length(files)
    file = files{i};
    info = load(file);
    info = info.warped_sector_info;
    area = cat(2, area, info.ellipArea);
end
area = area/number_of_pixels_per_cell;
area(area<=1) = [];
[n, x] = hist(log2(area), 30);
