function stage_grid = interpolateGrowthField(stage_grid)


    T = stage_grid.tri_info.T;
    pts = stage_grid.tri_info.pts;
    regions_ind = stage_grid.region_tri_ind;
    num_regs = length(regions_ind);
    num_tri = size(T,1);

    centroid = zeros(num_regs, 2);
    P = zeros(num_regs, 3);

    for i=1:num_regs
        triind =  regions_ind{i};
        xyind = T(triind,:);
        xyind = unique(xyind(:));
        reg_tensor = stage_grid.ungrowth_tensors(:,:,i);
       % [ major, minor, theta ] = growthParamsFromTensor( reg_tensor );
        [major, minor, theta] = gtlib_growthTensor2Params(reg_tensor);
        P(i,:) = [major, minor, theta];
        centroid(i,:) = mean(pts(xyind,:));
    end

    tri_cent = zeros(num_tri, 2);
    for i=1:num_tri
        tri_cent(i,:) = mean(pts(T(i,:),:));
    end

    mthd = 'nearest';
    mthd = 'v4';
    newP = zeros(num_tri, 3);

    if size(P,1)==1
        newP = repmat(P, [size(tri_cent,1), 1]);
    else
        newP(:,1) = griddata(centroid(:,1),centroid(:,2), P(:,1), tri_cent(:,1), tri_cent(:,2), mthd);
        newP(:,2) = griddata(centroid(:,1),centroid(:,2), P(:,2), tri_cent(:,1), tri_cent(:,2), mthd);
        newP(:,3) = griddata(centroid(:,1),centroid(:,2), P(:,3), tri_cent(:,1), tri_cent(:,2), mthd);
    end
%     hold on;
%     cla
%     id = 3;
%     plot3(tri_cent(:,1), tri_cent(:,2), newP(:,id), '.');
%     plot3(centroid(:,1), centroid(:,2), P(:,id), 'ro');
%     axis vis3d tight;

    tensors = zeros(3,3,num_tri);
    for i=1:num_tri
        regions_ind{i} = i;
        tensors(:,:,i) = gtlib_growthParams2Tensor(newP(i,1), newP(i,2), newP(i,3));
    end
    stage_grid.region_tri_ind = regions_ind;
    stage_grid.ungrowth_tensors = tensors;




return