function [] = show_average_ellipses_all_stages()
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
d = dir('Staged');
str = {d.name};
[s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
if v == 0
    fprintf('Must choose location of your mean shape\n');
    return;
end
mean_shape_dir =   ['Staged', filesep,  str{s}];

d = dir(['Staged', filesep, 'Data']);
str = {d.name};
[s,v] = listdlg('PromptString','Select a grid structure:','SelectionMode','single','ListString',str);
if v == 0
    fprintf('Sorry not a valid SectorAnalysis project directory\n');
    return;
end
grid_file =   [str{s}];
grid_path = ['Staged', filesep, 'Data'];

d = dir(stage_dir);
str = {d.name};
[s,v] = listdlg('PromptString','Select a grid:','SelectionMode','single','ListString',str);
if v == 0
    fprintf('Sorry not a valid SectorAnalysis project directory\n');
    return;
end
average_sector_data = str{s};
figure(1); clf; hold on;
set(gcf, 'Name', ['Information for stage ', stage_dir]);
plot_mean_shape(gca, mean_shape_dir);
info = load([stage_dir,filesep, average_sector_data]);
info = info.average_sector_info;
grid_info = load(['Staged', filesep, 'Data', filesep, average_sector_data(21:end)]);
grid_outline = grid_info.region_info.grid_xy;
plot(grid_outline(:,2), grid_outline(:,1), '.');
scale = 3;
for i=1:size(info,1)
    ei.Orientation = info(i, 6);
    ei.MajorAxisLength = info(i, 4)*scale;
    ei.MinorAxisLength = info(i, 5)*scale;
    ei.Centroid = info(i,1:2)';
    ei.Area = info(i, 3);
    eh = plot_ellipse(gca, ei);
    %eh = plot_ellipse_axis(gca, ei, 'r');
end
axis image
