function satlib_drawGridData(varargin)
% function satlib_drawGridData(varargin)
%
% This method takes a grid and draws the growth information on the grid.
%
% Inputs: 
% grid (default = [])
% colours (default = 'g')
% axish (default = [])
% edgecolor (default = 'k')
% tensorcol (default = 'k')
%
% Dr. A. I. Hanna, CMP & JIC, Norwich, UK, 2008

data = parseargs(varargin);
g = data.grid;
cols = data.colours;


pts = g.tri_info.pts;
T = g.tri_info.T;

r_ind = g.region_tri_ind;
centroids = calcStageGridCentroids(g);
num_regions = length(g.region_tri_ind);

satlib_plot_region_patches('regions', g.region_tri_ind, 'T', T, 'pts', pts, ...
    'parent', data.axish, 'FaceColours', cols, 'EdgeColor', data.edgecolor, 'linewidth', data.linewidth);
r = 10;
for j=1:num_regions
    mu = centroids(j,:);
    if  data.showtensors
        T = g.ungrowth_tensors(:,:,j);
        %gtlib_plotGrowthTensor('growth_tensor', T, 'offset', mu, 'colour', [0 0 0], 'Parent', data.axish, 'scale', r);
        if data.tensortype(1)==1
            plotPrincipalDirection(T, mu, data.tensorcol, data.axish, data.linewidth, ...
                data.tensorscalefactor, data.tensorthreshold, data.tensoruniscale, data.tensortype);
        end
        if data.tensortype(2)==1
            plotMinorDirection(T, mu, data.tensorcol, data.axish, data.linewidth, ...
                data.tensorscalefactor, data.tensorthreshold, data.tensoruniscale, data.tensortype);
        end

    end
end
return;
%%
%
function plotMinorDirection(T, mu, col, axish, linwidth, scalefactor, thr, uniscale, tensortype)
[major, minor, theta] = gtlib_growthTensor2Params(T);

val = minor;
theta = theta + pi/2;
if val<=thr
    return
end
if uniscale
    scale = scalefactor;
else
    scale = val*scalefactor;
end
x = scale*cos(theta);
y = scale*sin(theta);
ph = [];
ph = cat(2, ph, plot(axish, [mu(1) mu(1) + x], [mu(2) mu(2) + y], 'Color', col, 'LineWidth', linwidth));
ph = cat(2, ph, plot(axish, [mu(1) mu(1) - x], [mu(2) mu(2) - y], 'Color', col, 'LineWidth', linwidth));

return
%%
%
function plotPrincipalDirection(T, mu, col, axish, linwidth, scalefactor, thr, uniscale, tensortype)
[major, minor, theta] = gtlib_growthTensor2Params(T);
val = major;
if val<=thr
    return
end
if uniscale
    scale = scalefactor;
else
    scale = val*scalefactor;
end
x = scale*cos(theta);
y = scale*sin(theta);
ph = [];
ph = cat(2, ph, plot(axish, [mu(1) mu(1) + x], [mu(2) mu(2) + y], 'Color', col, 'LineWidth', linwidth));
ph = cat(2, ph, plot(axish, [mu(1) mu(1) - x], [mu(2) mu(2) - y], 'Color', col, 'LineWidth', linwidth));

return
%%
%
function data = parseargs(varargin)
varargin = varargin{1};
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to show_region_areal_growth must come param/value in pairs.')
end
data.tensortype = [1 1];
data.grid = [];
data.colours = 'g';
data.axish = [];
data.edgecolor = 'k';
data.tensorcol = 'k';
data.showtensors = 1;
data.linewidth = 1;
data.tensorscalefactor = 1;
data.tensorthreshold = 0;
data.tensoruniscale = 0;
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'tensortype'
            data.tensortype = varargin{i+1};
        case 'tensoruniscale'
            data.tensoruniscale = varargin{i+1};
        case 'tensorscalefactor'
            data.tensorscalefactor = varargin{i+1};
        case 'tensorthreshold'
            data.tensorthreshold = varargin{i+1};
        case 'grid'
            data.grid = varargin{i+1};
        case 'colours'
            data.colours = varargin{i+1};
        case 'parent'
            data.axish = varargin{i+1};
        case 'edgecolor'
            data.edgecolor = varargin{i+1};
        case 'showtensors'
            data.showtensors = varargin{i+1};
        case 'tensorcol'
            data.tensorcol = varargin{i+1};
        case 'linewidth'
            data.linewidth = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, ' show_region_areal_growth.  Name was ' varargin{i}])
    end
end
if isempty(data.axish)
    data.axish = gca;
end
return