%
% show_average_stage_growth_rate(mean_shape_dir, grid_name)
%
% Dr. A. I. Hanna (2005);
function show_average_stage_growth_rate(mean_shape_dir, grid_name)
stagedDir = ['Staged'];
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];

if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
d = dir(stagedDir);
str = {d.name};
if nargin<1
    [s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir =   ['Staged', filesep,  str{s}];
end
files = dir(stagedDir);
files = {files.name};
ind = [];
for f = 1:length(files)
    file = files{f};
    if (file(1) == '.') | strcmp(file, 'Data')
        ind = [ind; f];
    end
end
files(ind) = [];
if nargin<2
    d = dir([gridDir, filesep, '*.mat']);
    if isempty(d)
        fprintf('Could not find any grids in %s, sorry. Returning to Stat Viewer Tool.\n', gridDir);
        return;
    end
    str = {d.name};
    [s,v] = listdlg('PromptString','Select a grid:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Sorry not a valid SectorAnalysis project directory\n');
        return;
    end
    grid_file =   [str{s}];
end
files = findfiles(['average_sector_info_', grid_file], stagedDir);

if isempty(files)
    fprintf('Could not find any files named %s in %s, sorry.\n', ['average_sector_info_', grid_file], stagedDir);
    return;
end

grid_info = load([gridDir, filesep, grid_file]);
grid_outline = grid_info.region_info.grid_xy;
num_cols =2;
N = length(files);
M = ceil(N/num_cols);
N = num_cols;
movegui(gcf, 'center');
c = 1;
max_area = 0;
for i=1:length(files)
    info = load(files{i});
    info = info.average_sector_info;
    if (ceil(max(info(:,3))))>max_area
        max_area = ceil(max(info(:,3)));
    end
end
map = cool(12);

[files, value] = SelectOrderListDlg('liststring', files);
M = 3; N = 2; indx = 1;
figure;
for i=1:length(files)
    Q = zeros([size(grid_info.region_info.R(:,:,1)), 3]);
    if i==1
        growth_rate = zeros(size(info,1), 1);
    else
        area_k = load(files{i});
        area_k = area_k.average_sector_info(:,3);
        area_k_d = load(files{i-1});
        area_k_d = area_k_d.average_sector_info(:,3);
        growth_rate = area_k./area_k_d;
    end
    growth_rate
    for ii=1:size(growth_rate,1)
        r = grid_info.region_info.R(:,:,ii+1);
        [x, y] = find(r==1);
        col = growth_rate2colour(growth_rate(ii));
        for k=1:length(x)
            Q(x(k), y(k), 1) =  col(1);
            Q(x(k), y(k), 2) =  col(2);
            Q(x(k), y(k), 3) =  col(3);
        end
        fprintf('.');
    end
    fprintf('\n');
    if indx>M*N
        figure;
        indx = 1;
    end
    subplot(M, N, indx); indx = indx+1;
    imagesc(Q);
    colorbar;
end

return;



% for i=1:length(files)
%     subaxis(M, N, c,'Spacing',.01, 'MR', .1);
%     hold(gca, 'on');
%     info = load(files{i});
%     info = info.average_sector_info;
%     Q = zeros([size(grid_info.region_info.R(:,:,1)), 3]);
%     
%     fprintf('Processing %s\n', files{i});
%     for ii=1:size(info,1); fprintf('*'); end; fprintf('\n');
%     for ii=1:size(info,1)
%         area = info(ii, 3);
%         r = grid_info.region_info.R(:,:,ii+1);
%         [x, y] = find(r==1);
%         for k=1:length(x)
%            Q(x(k), y(k), 1) =  map(ceil(area)+1, 1);
%            Q(x(k), y(k), 2) =  map(ceil(area)+1, 2);
%            Q(x(k), y(k), 3) =  map(ceil(area)+1, 3);
%         end
%         pause(.01);
%         fprintf('.');
%     end
%     fprintf('\n');
%     imagesc(Q./max(Q(:)));
%     axis image ij;
%     [path, file, ext, vers] = fileparts(files{i}); 
%     [path, file, ext, vers] = fileparts(path); 
%     title(file);
%     set(gca, 'XTickLabel', [], 'YTickLabel', []);
%     grid on;
%     drawnow;
%     c = c+1;
% end