%
% [ma] = show_mean_sector_area()
%
% Dr. A. I. Hanna (2005);
function [ma] = show_mean_sector_area()
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
% Set up some directory constants
stagedDir = 'Staged';
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];

figure;
files = dir(stagedDir);
files = {files.name};
ind = [];
for f = 1:length(files)
    file = files{f};
    if (file(1) == '.') || strcmp(file, 'Data')
        ind = [ind; f];
    end
end
files(ind) = [];
ma = [];
for f=1:length(files)
    file = files{f};

    files2 = findfiles('warped_sector_info.mat', [stagedDir, filesep, file]);
    
    area = [];
    for i=1:length(files2)
        info = load(files2{i});
        info = info.warped_sector_info;
        area = cat(1, area, mean([info.ellipArea]));
    end
    if ~isempty(area)
        ma = cat(1, ma, mean(area));
    else
        ma = cat(1, ma, 0);
    end
end
ppc = get_pixel_per_cell_value;
ma = ma/ppc;
plot(ma, '-o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'r', 'Color', 'b');
set(gca, 'XTick', 1:length(files), 'XTickLabel', files);
xlabel('Developmental Stage');
ylabel('mean sector area (in cell numbers)');
grid on;
title('Developmental Stage v''s Sector Area');
axis tight;
