%Hanna, 2005
function [value] = EdgeEditor(varargin)
if checkSATDir(pwd) == 0
    fprintf('You are not in a valid SectorAnalysisToolbox Project directory\n');
    return;
end
error(nargchk(0,inf,nargin));
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to LISTDLG must come param/value in pairs.')
end
Edgs = [];
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'springstructure'
            Springs = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to LISTDLG.  Name was ' varargin{i}])
    end
end
if isempty(Springs)
    error('springstructure parameter is required.')
end
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
movegui(fig, 'center');
set(fig, 'Visible', 'on');
handles = guihandles(fig);
% Set all the callback functions

%set(handles.zoom_btn, 'callback', {@doZoom});


% Initialize the application data structure
ad.figMain = fig;
ad.value = 0;
ad.handles = handles;
ad.Springs = Springs;
setappdata(0,'EdgeEditorData',ad);
concavitycheck(Springs.S, Springs.Edgs, Springs.E)
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
value = 0;
return;

