function pts = getRegionCornerPts(subim)
pts = [];
% the sub image was empty
if sum(subim(:))==0
    return;
end
[rows, cols] = size(subim);
ind = find(subim(1,:));
if ~isempty(ind)
    pts = cat(2, pts, [min(ind); 1]);
    pts = cat(2, pts, [max(ind); 1]);
    
end
ind = find(subim(:,1));
if ~isempty(ind)
    pts = cat(2, pts, [1; min(ind)]);
    pts = cat(2, pts, [1; max(ind)]);
    
end
ind = find(subim(rows,:));
if ~isempty(ind)
    pts = cat(2, pts, [min(ind); rows]);
    pts = cat(2, pts, [max(ind); rows]);
    
end
ind = find(subim(:,cols));
if ~isempty(ind)
        pts = cat(2, pts, [cols; min(ind)]);
    pts = cat(2, pts, [cols; max(ind)]);
end
pts = unique(pts', 'rows');
return
